<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFlightaircraftsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('flightaircrafts', function (Blueprint $table) {
            $table->increments('id');
            $table->string('image_name')->nullable();
            $table->string('category')->nullable();
            $table->string('id_backend')->nullable();
            $table->string('type')->nullable();
            $table->string('manufacturer')->nullable();
            $table->string('model')->nullable();
            $table->string('display_manufacturer')->nullable();
            $table->string('display_name')->nullable();
            $table->string('variant')->nullable();
            $table->string('callsign')->nullable();
            $table->string('unit')->nullable();
            $table->string('BEW')->nullable();
            $table->string('moment_long')->nullable();
            $table->string('moment_lat')->nullable();
            $table->string('MTOW')->nullable();
            $table->string('max_fuel')->nullable();
            $table->text('description_line1')->nullable();
            $table->text('description_line2')->nullable();
            $table->string('version')->nullable();
            $table->string('internal_remarks')->nullable();
            $table->unsignedInteger('position')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('flightaircrafts');
    }
}
